//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#define sorttype double
#include "SortThread.cpp"

#include <typeinfo.h> //potrzebne do typeid
#include <time.h> //potrzebne do time_t, time()

#include "Unit1.h"

//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
BubbleSortThread=NULL;
SelectionSortThread=NULL;
InsertSortThread=NULL;
QuickSortThread=NULL;
Dane=NULL;
Dane_ile=0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ClearListBoxes(TObject *Sender)
{
ListBox1->Color=clBtnFace;
ListBox2->Color=clBtnFace;
ListBox3->Color=clBtnFace;
ListBox4->Color=clBtnFace;
ListBox5->Color=clBtnFace;
ListBox1->Clear();
ListBox2->Clear();
ListBox3->Clear();
ListBox4->Clear();
ListBox5->Clear();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::GenerujDane()
{
//Czyszczenie ListBoxow
ClearListBoxes(this);

//Ile elementow (odczyt z Edit1)
Dane_ile=Edit1->Text.ToInt();
Dane=(sorttype *)calloc(Dane_ile,sizeof(sorttype));

//Tworzenie listy liczb pseudolosowych
randomize();
for (int i=0; i<Dane_ile; i++)
	{
	if (typeid(sorttype)==typeid(double)) Dane[i]=Dane_ile*random(Dane_ile)/(1.0+random(Dane_ile));
    if (typeid(sorttype)==typeid(int)) Dane[i]=random(Dane_ile);
    }

//Zapis liczb do ListBox1
ListBox1->Color=clWindow;
ListBox1->Items->Clear();
for (int i=0; i<Dane_ile; i++) ListBox1->Items->Add(Dane[i]);
ListBox1->Refresh();
}

void __fastcall TForm1::Sortowanie(bool rownolegle)
{
//Sprawdzenie czy dane wejsciowe istnieja
if (Dane==NULL)
	{
    ShowMessage("Brak danych");
    return;
    }

//Sprawdzenie czy poprzednie sortowanie zostalo zakonczone
if (BubbleSortThread!=NULL || SelectionSortThread!=NULL ||
    InsertSortThread!=NULL || QuickSortThread!=NULL)
    	{
        ShowMessage("Wtki nadal dziaaj!");
        return;
        }


//Tworzenie watkow
bool CreateSuspend=true;

BubbleSortThread=new TSortThread(Dane,Dane_ile,CreateSuspend);
BubbleSortThread->SortMethod=smBubble;
BubbleSortThread->OutputListBox=ListBox2;

SelectionSortThread=new TSortThread(Dane,Dane_ile,CreateSuspend);
SelectionSortThread->SortMethod=smSelection;
SelectionSortThread->OutputListBox=ListBox3;

InsertSortThread=new TSortThread(Dane,Dane_ile,CreateSuspend);
InsertSortThread->SortMethod=smInsert;
InsertSortThread->OutputListBox=ListBox4;

QuickSortThread=new TSortThread(Dane,Dane_ile,CreateSuspend);
QuickSortThread->SortMethod=smQuick;
QuickSortThread->OutputListBox=ListBox5;

//Ustalanie koloru w zaleznosci od trybu (rownolegly/szeregowy)
TColor kolor=clLime;
if (rownolegle) kolor=clYellow;
BubbleSortThread->OutputListBoxColor=SelectionSortThread->OutputListBoxColor=InsertSortThread->OutputListBoxColor=QuickSortThread->OutputListBoxColor=kolor;

//Modyfikacja priorytetow
BubbleSortThread->Priority=tpHighest;
QuickSortThread->Priority=tpLowest;
ShowMessage("Priorytety wtkw zostay zmodyfikowane");

if (rownolegle)
	{
    //Uruchamianie rownolegle watkow
    time(&parallel_starttime);

    //Dodawanie metody zdarzeniowej OnTerminate
	BubbleSortThread->OnTerminate=ThreadTerminate;
	SelectionSortThread->OnTerminate=ThreadTerminate;
	InsertSortThread->OnTerminate=ThreadTerminate;
	QuickSortThread->OnTerminate=ThreadTerminate;

	BubbleSortThread->Resume();
	SelectionSortThread->Resume();
	InsertSortThread->Resume();
	QuickSortThread->Resume();
    //Ustalenie FreeOnTerminate zwalnia nas od usuwania watkow (JEZELI WYWOLANE Resume())
	//(nie moznabyloby tego zrobic tutaj, bo jeszcze sie nie skonczylo sortowanie)
    }
	else
	{
    //Uruchamianie watkow szeregowe
    Screen->Cursor=crHourGlass;
	time_t starttime,stoptime;
	time(&starttime);

	BubbleSortThread->Execute(); delete BubbleSortThread; BubbleSortThread=NULL;
	SelectionSortThread->Execute(); delete SelectionSortThread; SelectionSortThread=NULL;
	InsertSortThread->Execute(); delete InsertSortThread; InsertSortThread=NULL;
	QuickSortThread->Execute();	delete QuickSortThread; QuickSortThread=NULL;

    time(&stoptime);
	Label9->Caption=(AnsiString)(double)(stoptime-starttime);
	Screen->Cursor=crDefault;
    }

}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
GenerujDane();
Sortowanie(RadioButton1->Checked);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
//Sprawdzenie czy obiekty watkow istnieja
if (BubbleSortThread==NULL || SelectionSortThread==NULL ||
    InsertSortThread==NULL || QuickSortThread==NULL)
    	{
        ShowMessage("Obiekty watkow nie istnieja!");
        return;
        }

/*
//Zawieszenie dzialania watkow
BubbleSortThread->Suspend();
SelectionSortThread->Suspend();
InsertSortThread->Suspend();
QuickSortThread->Suspend();
*/


//Zawieszenie/Wznawianie dzialania watkow
BubbleSortThread->Suspended=!BubbleSortThread->Suspended;
SelectionSortThread->Suspended=!SelectionSortThread->Suspended;
InsertSortThread->Suspended=!InsertSortThread->Suspended;
QuickSortThread->Suspended=!QuickSortThread->Suspended;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
//Sprawdzenie czy obiekty watkow istnieja
if (BubbleSortThread==NULL || SelectionSortThread==NULL ||
    InsertSortThread==NULL || QuickSortThread==NULL)
    	{
        ShowMessage("Obiekty watkow nie istnieja!");
        return;
        }

//Przerywanie dzialania watkow
BubbleSortThread->Terminate();
SelectionSortThread->Terminate();
InsertSortThread->Terminate();
QuickSortThread->Terminate();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button5Click(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ThreadTerminate(TObject* Sender)
{
//Zostanie zapis z ostatniego
time_t stoptime;
time(&stoptime);
Label10->Caption=(AnsiString)(double)(stoptime-parallel_starttime);

static licznik=0;
licznik++;
if (licznik==4)
	{
    //Aplikacja sprawdza wartosc tych wskaznikow zeby sprawdzic czy watki dzialaja
    BubbleSortThread=NULL;
    SelectionSortThread=NULL;
    InsertSortThread=NULL;
    QuickSortThread=NULL;
    licznik=0;
    }
}

void __fastcall TForm1::Button6Click(TObject *Sender)
{
//Sprawdzenie czy obiekty watkow istnieja
if (BubbleSortThread==NULL || SelectionSortThread==NULL ||
    InsertSortThread==NULL || QuickSortThread==NULL)
    	{
        ShowMessage("Obiekty watkow nie istnieja!");
        return;
        }

//Zabijanie wszystkich watkow
TerminateThread((void*)BubbleSortThread->Handle,0);
TerminateThread((void*)SelectionSortThread->Handle,0);
TerminateThread((void*)InsertSortThread->Handle,0);
TerminateThread((void*)QuickSortThread->Handle,0);

//Sami musimy zadbac o usuniecie obiektow
delete BubbleSortThread; BubbleSortThread=NULL;
delete SelectionSortThread; SelectionSortThread=NULL;
delete InsertSortThread; InsertSortThread=NULL;
delete QuickSortThread; QuickSortThread=NULL;
}
//---------------------------------------------------------------------------
